<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pedido extends Model 
{

    protected $table = 'pedidos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function estado()
    {
        return $this->hasOne('EstadosPago', 'estado_id');
    }

    public function envio()
    {
        return $this->hasOne('Envio');
    }

    public function viaje()
    {
        return $this->hasOne('\Viaje');
    }

}