<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestLogTable extends Migration {

	public function up()
	{
		Schema::create('request_log', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('request_id')->unsigned()->index();
			$table->integer('user_id')->unsigned()->index();
			$table->text('log_content');
		});
	}

	public function down()
	{
		Schema::drop('request_log');
	}
}