<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Voucher extends Eloquent {

	protected $table = 'vouchers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('voucher_code', 'agent_name', 'agent_phone', 'hotel_name', 'hotel_address', 'agency_name', 'agency_rnc', 'agency_phone', 'agency_address', 'route_name', 'route_address', 'route_collection_location', 'route_collection_time', 'grand_total', 'status');
	protected $visible = array('status');

	public function reservation()
	{
		return $this->belongsTo('Reservation', 'reservation_id');
	}

	public function reservationPackages()
	{
		return $this->hasMany('ReservationPackage', 'reservation_id');
	}

}