<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('username', 'name', 'last_name', 'email');

    public function role()
    {
        return $this->belongsToMany('Role', 'user_id');
    }

    public function attempts()
    {
        return $this->hasMany('Login_attempts');
    }

}