<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Voucher extends Model 
{

    protected $table = 'vouchers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('voucher_code', 'agent_name', 'agent_phone', 'hotel_name', 'hotel_address', 'agency_name', 'agency_rnc', 'agency_phone', 'agency_address', 'route_name', 'route_address', 'route_collection_location', 'route_collection_time', 'grand_total', 'status');
    protected $visible = array('status');

    public function reservation()
    {
        return $this->belongsTo('Reservation', 'reservation_id');
    }

    public function reservationPackages()
    {
        return $this->hasMany('ReservationPackage', 'reservation_id');
    }

}