<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssetTransferTable extends Migration {

	public function up()
	{
		Schema::create('asset_transfer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('previous_location_id')->unsigned();
			$table->integer('previous_cinema_id')->unsigned();
			$table->integer('current_location_id')->unsigned();
			$table->integer('current_cinema_id')->unsigned();
			$table->string('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('asset_transfer');
	}
}