<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('company_id')->unsigned()->nullable();
			$table->string('username');
			$table->string('email')->unique();
			$table->string('phone');
			$table->string('remenber_token', 255)->nullable();
			$table->string('password', 255);
			$table->integer('role_id')->unsigned();
			$table->integer('department_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}