<?php

namespace models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('name', 'maxmim_stock_for_client', 'weight', 'sku', 'description', 'stock', 'regluar_price', 'is_sale', 'sale_precent', 'sale_expire_date', 'catching_word', 'code', 'status', 'brand');

    public function Galleries()
    {
        return $this->hasMany('models\Gallery');
    }

    public function Carts()
    {
        return $this->belongsToMany('models\UserProduct');
    }

    public function Orders()
    {
        return $this->belongsToMany('models\ProductOrder');
    }

    public function options()
    {
        return $this->hasMany('\Option');
    }

}