<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('name_en', 255);
			$table->text('background_image')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('price_after');
			$table->decimal('price_before');
			$table->integer('days_limit_for_free')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}