<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionTable extends Migration {

	public function up()
	{
		Schema::create('subscription', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('package_id')->index();
			$table->integer('client_id');
			$table->date('start_date');
			$table->date('end_date');
			$table->string('paid', 255);
		});
	}

	public function down()
	{
		Schema::drop('subscription');
	}
}