<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'phone', 'package_id', 'price');

	public function features()
	{
		return $this->belongsToMany('Feature');
	}

	public function accounts()
	{
		return $this->hasMany('Account');
	}

	public function tickets()
	{
		return $this->hasMany('Ticket');
	}

	public function package()
	{
		return $this->belongsTo('Packages');
	}

	public function subscriptions()
	{
		return $this->hasMany('Subscription');
	}

}