<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->enum('type', array('SuperAdmin', 'Admin', 'User', 'Vendor'));
			$table->string('address', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('fax', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('password')->nullable();
			$table->string('image', 255)->nullable();
			$table->string('store_name', 255)->nullable();
			$table->string('store_link')->nullable();
			$table->string('firebase_token', 255)->nullable();
			$table->string('email_verified_at', 255)->nullable();
			$table->boolean('status')->nullable()->default(1);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}