<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->string('price')->nullable();
			$table->string('discount_price')->nullable();
			$table->string('code')->nullable();
			$table->string('description_ar')->nullable();
			$table->string('description_en')->nullable();
			$table->string('image')->nullable();
			$table->integer('category_id')->unsigned();
			$table->string('unit')->nullable();
			$table->boolean('published')->nullable()->default(1);
			$table->string('extras')->nullable();
			$table->integer('tag_id')->unsigned();
			$table->integer('shop_id')->nullable();
			$table->string('quantity')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}