<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressTable extends Migration {

	public function up()
	{
		Schema::create('Address', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('isUserType');
			$table->boolean('isShopType');
			$table->boolean('isShippingType');
			$table->boolean('isBillingType');
			$table->string('houseFlatNumber', 250);
			$table->string('houseName', 250);
			$table->string('streetName', 250);
			$table->string('city', 250);
			$table->string('countyState', 250);
			$table->string('postCode', 250);
			$table->string('country', 250);
			$table->bigIncrements('userId');
			$table->bigIncrements('storeId');
		});
	}

	public function down()
	{
		Schema::drop('Address');
	}
}