<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CategoryCountry extends Model 
{

    protected $table = 'category_country';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'category_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}