<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientOrder extends Model 
{

    protected $table = 'client_order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'country_id', 'total', 'payment_method', 'status');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function products()
    {
        return $this->hasMany('OrderProduct', 'order_id');
    }

}