<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Mall extends Model 
{

    protected $table = 'mall';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'country_id', 'name_en', 'name_ar', 'area_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function parks()
    {
        return $this->hasMany('Park', 'mall_id');
    }

    public function area()
    {
        return $this->belongsTo('Area', 'area_id');
    }

}