<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderCover extends Model 
{

    protected $table = 'order_cover';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'cover_id', 'quantity', 'price', 'total', 'country_id');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function cover()
    {
        return $this->belongsTo('Cover', 'cover_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}