<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBannerTable extends Migration {

	public function up()
	{
		Schema::create('banner', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->text('description')->nullable();
			$table->string('image_path');
			$table->string('link_url')->nullable();
			$table->tinyInteger('is_active')->default('0');
			$table->timestamps();
			$table->timestamp('softDeletes');
		});
	}

	public function down()
	{
		Schema::drop('banner');
	}
}