<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModulesTable extends Migration {

	public function up()
	{
		Schema::create('modules', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->string('name', 255);
			$table->text('description');
			$table->timestamp('start_date');
			$table->timestamp('end_date');
			$table->tinyInteger('visible')->default('1');
			$table->timestamps();
			$table->integer('n_problems');
			$table->integer('n_resources');
		});
	}

	public function down()
	{
		Schema::drop('modules');
	}
}