<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDuelsTable extends Migration {

	public function up()
	{
		Schema::create('duels', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->integer('problem_id')->unsigned();
			$table->integer('defiant_user_id')->unsigned();
			$table->integer('opponent_user_id')->unsigned()->nullable();
			$table->integer('bet')->unsigned();
			$table->integer('winner_user_id')->unsigned()->nullable();
			$table->tinyInteger('status')->default('0');
			$table->string('defiant_responded')->default('0');
			$table->tinyInteger('opponent_responded')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('duels');
	}
}