<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModuleResourceTable extends Migration {

	public function up()
	{
		Schema::create('module_resource', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('module_id')->unsigned();
			$table->integer('resource_id')->unsigned();
			$table->decimal('n_rating_avg', 8,2)->default('0');
			$table->integer('n_rating_count');
			$table->tinyInteger('visible');
			$table->integer('n_resources_views');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('module_resource');
	}
}