<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('reached_achievement_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('course_id')->unsigned();
			$table->string('url');
			$table->string('image');
			$table->string('title');
			$table->string('body', 512);
			$table->tinyInteger('viewed');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}