<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromotionsTable extends Migration {

	public function up()
	{
		Schema::create('promotions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('image_name', 255)->nullable();
			$table->string('name', 200);
			$table->text('description')->nullable();
			$table->smallInteger('max_discount_percent')->default('0');
			$table->tinyInteger('active')->index()->default('1');
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('promotions');
	}
}