<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWarrantiesTable extends Migration {

	public function up()
	{
		Schema::create('warranties', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->tinyInteger('active')->index()->default('1');
			$table->text('description')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('warranties');
	}
}