<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('member_id')->unsigned()->nullable()->index();
			$table->string('fullname', 150);
			$table->string('phone', 30)->nullable();
			$table->string('address', 255);
			$table->integer('district_id')->unsigned()->index();
			$table->integer('amphur_id')->unsigned()->index();
			$table->integer('province_id')->unsigned()->index();
			$table->integer('zipcode_id')->unsigned()->index();
			$table->decimal('total_price')->default('0');
			$table->decimal('discount_price')->default('0');
			$table->integer('coupon_id')->unsigned()->nullable()->index();
			$table->decimal('coupon_discount')->default('0');
			$table->decimal('net_price')->default('0');
			$table->text('remark')->nullable();
			$table->integer('shipping_id')->unsigned()->nullable()->index();
			$table->decimal('shipping_price')->default('0');
			$table->string('tracking_no', 50)->nullable();
			$table->datetime('shipping_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}