<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('beer_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('beer_user', function(Blueprint $table) {
			$table->foreign('beer_id')->references('id')->on('beers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('beer_user', function(Blueprint $table) {
			$table->dropForeign('beer_user_user_id_foreign');
		});
		Schema::table('beer_user', function(Blueprint $table) {
			$table->dropForeign('beer_user_beer_id_foreign');
		});
	}
}