<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssetsTable extends Migration {

	public function up()
	{
		Schema::create('assets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->integer('tipe_asset_id');
			$table->text('kronologis')->nullable();
			$table->integer('nama_barang_id');
			$table->string('nup')->nullable();
			$table->string('lokasi')->nullable();
			$table->integer('wilayah_id')->nullable();
			$table->string('luas_tanah')->nullable();
			$table->string('penggunaan')->nullable();
			$table->string('luas_dasar_gedung')->nullable();
			$table->string('luas_gedung')->nullable();
			$table->smallInteger('jumlah_lantai')->nullable();
			$table->date('tgl_perolehan')->nullable();
			$table->string('nilai_satuan')->nullable();
			$table->string('jumlah_nilai')->nullable();
			$table->tinyInteger('kondisi_id')->nullable();
			$table->string('status_sengketa')->default('Tidak sengketa');
			$table->string('no_psp')->nullable();
			$table->string('dokumen_psp')->nullable();
			$table->text('ket_penggunaan')->nullable();
			$table->string('kib')->nullable();
			$table->text('permasalahan')->nullable();
			$table->string('no_sip')->nullable();
			$table->string('no_sk_penetapan')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->integer('satker_id');
			$table->integer('status_penggunaan_id')->nullable();
			$table->string('plat_nomor', 15)->nullable();
			$table->string('kubikasi', 10)->nullable();
			$table->integer('merek_id')->nullable();
			$table->string('jenis_kendaraan')->nullable();
			$table->string('tahun_pembuatan', 10)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('assets');
	}
}