<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenusTable extends Migration {

	public function up()
	{
		Schema::create('menus', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('menu_title');
			$table->string('target')->nullable()->default('url_link');
			$table->integer('article_id')->nullable();
			$table->string('link_url')->nullable();
			$table->integer('parent_id')->default('0');
			$table->integer('order_number')->default('0');
			$table->integer('menu_item_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('menus');
	}
}