<?php

namespace App;

class Article extends Eloquent {

	protected $table = 'articles';
	public $timestamps = true;
	protected $fillable = array('user_id', 'category_id', 'title', 'content', 'mulai', 'selesai');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function headline()
	{
		return $this->hasOne('Headline');
	}

	public function image()
	{
		return $this->hasMany('Image');
	}

	public function category()
	{
		return $this->belongsTo('Category');
	}

}