<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Store extends Model 
{

    protected $table = 'stores';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function timing()
    {
        return $this->hasOne('StoreTiming', 'store_id');
    }

    public function services()
    {
        return $this->hasMany('StoreServices', 'store_id');
    }

    public function reviews()
    {
        return $this->hasMany('Review', 'store_id');
    }

}