<?php

namespace Review;

use Illuminate\Database\Eloquent\Model;

class Review extends Model 
{

    protected $table = 'reviews';
    public $timestamps = true;

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function client()
    {
        return $this->belongsTo('User', 'client_id');
    }

    public function reservation()
    {
        return $this->belongsTo('Reservation', 'reservation_id');
    }

    public function employees()
    {
        return $this->hasOne('ReviewEmployee', 'review_id');
    }

}