<?php

class Reservation extends Eloquent {

	protected $table = 'reservations';
	public $timestamps = true;

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function donation()
	{
		return $this->hasOne('ReservationDonation', 'reservation_id');
	}

	public function discard()
	{
		return $this->hasOne('DiscardReservation', 'reservation_id');
	}

	public function coupon()
	{
		return $this->belongsTo('Coupon', 'coupon_id');
	}

	public function items()
	{
		return $this->hasMany('ReservationItem', 'reservation_id');
	}

}