<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFamiliesTable extends Migration {

	public function up()
	{
		Schema::create('families', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('family_name', 191)->nullable();
			$table->string('commercial_name', 191)->nullable();
			$table->string('lat', 191)->nullable();
			$table->string('lng', 191)->nullable();
			$table->string('address', 191)->nullable();
			$table->string('id_number', 191)->nullable();
			$table->string('id_image', 191)->nullable();
			$table->string('bank_name', 191)->nullable();
			$table->string('bank_number', 191)->nullable();
			$table->string('iban_number', 191)->nullable();
			$table->string('tax_number', 191)->nullable();
			$table->string('health_image', 191)->nullable();
			$table->string('marketer_code', 191)->nullable();
			$table->enum('online', array('true', 'false'))->nullable();
			$table->enum('delivery', array('app', 'family'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('families');
	}
}