<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeviceTokensTable extends Migration {

	public function up()
	{
		Schema::create('device_tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('token', 191)->nullable();
			$table->enum('status', array('connected', 'disconnected'))->nullable();
			$table->enum('device_lang', array('ar', 'en'))->nullable();
			$table->enum('device_type', array('ios', 'android'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('device_tokens');
	}
}