<?php

namespace App;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'api_token', 'code_bin', 'image');
	protected $visible = array('activate');

	public function tokens()
	{
		return $this->morphMany('App\Token', 'tokenable');
	}

	public function orders()
	{
		return $this->hasMany('App\Order');
	}

	public function reviews()
	{
		return $this->hasMany('App\Review');
	}

	public function region()
	{
		return $this->belongsTo('App\Region');
	}

	public function notifactions()
	{
		return $this->morphMany('App\Notifaction', 'notifactionable');
	}

}