<?php

namespace App;

class Resturant extends Eloquent {

	protected $table = 'resturants';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'whatsup', 'image', 'minimum_order', 'contact_phone', 'delivery_charge', 'activate', 'available');

	public function tokens()
	{
		return $this->morphMany('App\Token', 'tokenable');
	}

	public function products()
	{
		return $this->hasMany('App\Product');
	}

	public function offers()
	{
		return $this->hasMany('App\Offer');
	}

	public function orders()
	{
		return $this->hasMany('App\Order');
	}

	public function reviews()
	{
		return $this->hasMany('App\Review');
	}

	public function region()
	{
		return $this->belongsTo('App\Region');
	}

	public function catogries()
	{
		return $this->belongsToMany('App\Category');
	}

	public function payment()
	{
		return $this->belongsTo('App\Payment');
	}

	public function notifactions()
	{
		return $this->morphMany('App\Notifaction');
	}

}