<?php

namespace App\Entities\Tally\Management;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function workPools()
	{
		return $this->hasMany('App\Entities\Tally\Management\Team', 'team_ids');
	}

}