<?php

namespace App\Entities\Tally\Management;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Team extends Eloquent {

	protected $table = 'teams';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('user_id', 'project_id');

	public function periods()
	{
		return $this->hasMany('App\Entities\Tally\Management\Period', 'period_ids');
	}

}