<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstallmentsTable extends Migration {

	public function up()
	{
		Schema::create('installments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('operattion_id')->unsigned();
			$table->date('date');
			$table->integer('amount');
			$table->tinyInteger('status');
			$table->integer('delay_penalty');
			$table->integer('provider_id')->unsigned();
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('installments');
	}
}