<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperattionsTable extends Migration {

	public function up()
	{
		Schema::create('operattions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('provider_id')->unsigned();
			$table->integer('client_id')->unsigned();
			$table->integer('installment_count');
			$table->integer('installment_amount');
			$table->integer('main_amount');
			$table->integer('total_required');
			$table->date('date');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('operattions');
	}
}