<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeachersTable extends Migration {

	public function up()
	{
		Schema::create('teachers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('school_id')->index();
			$table->string('name', 191)->index();
			$table->string('middle_name', 191)->nullable()->index();
			$table->string('last_name', 191)->nullable()->index();
			$table->string('username', 191)->unique()->nullable();
			$table->text('password');
			$table->string('email', 191)->unique()->nullable();
			$table->text('contact_no')->nullable();
			$table->text('description');
			$table->tinyInteger('active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('teachers');
	}
}