<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StageEmployee extends Model 
{

    protected $table = 'stage_employees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function stage()
    {
        return $this->belongsTo('App\Stage', 'id');
    }

    public function employee()
    {
        return $this->belongsTo('App\Employee', 'id');
    }

}