<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenusTable extends Migration {

	public function up()
	{
		Schema::create('menus', function(Blueprint $table) {
			$table->increments('id');
			$table->string('link');
			$table->integer('parent_id')->default('0');
			$table->string('name_en');
			$table->string('name_ar');
			$table->timestamps();
			$table->tinyInteger('activation')->default('1');
			$table->boolean('is_featured')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('menus');
	}
}