<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('category_id', 'name_en', 'name_ar', 'body_en', 'body_ar', 'excerpt_en', 'excerpt_ar', 'price', 'offer_price', 'activation', 'is_featured');

	public function photos()
	{
		return $this->morphMany('App\Models\Photo');
	}

	public function tags()
	{
		return $this->morphToMany('App\Models\Tag');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

}