<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_en');
			$table->string('name_ar');
			$table->string('excerpt_en');
			$table->string('excerpt_ar');
			$table->string('description_en');
			$table->string('description_ar');
			$table->timestamps();
			$table->tinyInteger('activation')->default('1');
			$table->boolean('is_featured')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}