<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntitiesSettingsTable extends Migration {

	public function up()
	{
		Schema::create('EntitiesSettings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->uuid('uuid')->nullable();
			$table->integer('order_type')->nullable();
			$table->double('commission')->nullable();
			$table->double('minimum_purchase')->nullable();
			$table->string('logo', 255)->nullable();
			$table->string('header', 255)->nullable();
			$table->string('About', 500)->nullable();
			$table->integer('status')->nullable();
			$table->string('status_message', 255)->nullable();
			$table->integer('packaging_type')->nullable();
			$table->double('packaging_charge')->nullable();
			$table->double('tax')->nullable();
			$table->time('delivery_time')->nullable();
			$table->integer('menu_type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('EntitiesSettings');
	}
}