<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('uuid', 90);
			$table->string('username', 255);
			$table->string('email', 255);
			$table->string('password', 255);
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->enum('user_type', array('('ADMIN'', ''MERCHANT')'));
			$table->tinyInteger('email_verified')->nullable()->default('0');
			$table->tinyInteger('password_changed')->nullable()->default('0');
			$table->string('email_verified_token', 255)->nullable();
			$table->string('password_changed_token', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}