<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('entity_branches', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('entity_branches', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('entity_branches', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entity_ratings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('consumer_users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('entity_ratings', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('payment_mode_id')->references('id')->on('payment_mode')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('payment_mode_id')->references('id')->on('payment_mode')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('tags_assigned', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('tags_assigned', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('sponsored', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('p_cat_id')->references('id')->on('product_categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('product_options_sub', function(Blueprint $table) {
			$table->foreign('p_cat_id')->references('id')->on('product_options')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('voucher_type')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('payment_mode_id')->references('id')->on('payment_mode')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('consumer_id')->references('id')->on('consumer_users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('consumers_addresses', function(Blueprint $table) {
			$table->foreign('consumer_user_id')->references('id')->on('consumer_users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('consumers_addresses', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('consumers_addresses', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('state')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('consumers_addresses', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('city')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('affliliates', function(Blueprint $table) {
			$table->foreign('affiliate_post_type_id')->references('id')->on('affiliate_post_type')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('affliliates', function(Blueprint $table) {
			$table->foreign('affilitate_package_id')->references('id')->on('affilitate_package')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('affliliates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('consumer_users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->foreign('tax_type')->references('id')->on('tax_type')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('state', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('state')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cuisine_assigned', function(Blueprint $table) {
			$table->foreign('cuisine_id')->references('id')->on('cuisines')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cuisine_assigned', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('EntitiesSettings', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('entity_branches', function(Blueprint $table) {
			$table->dropForeign('entity_branches_service_id_foreign');
		});
		Schema::table('entity_branches', function(Blueprint $table) {
			$table->dropForeign('entity_branches_status_id_foreign');
		});
		Schema::table('entity_branches', function(Blueprint $table) {
			$table->dropForeign('entity_branches_entity_id_foreign');
		});
		Schema::table('entity_ratings', function(Blueprint $table) {
			$table->dropForeign('entity_ratings_user_id_foreign');
		});
		Schema::table('entity_ratings', function(Blueprint $table) {
			$table->dropForeign('entity_ratings_entity_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_entity_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_payment_mode_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_order_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_payment_mode_id_foreign');
		});
		Schema::table('tags_assigned', function(Blueprint $table) {
			$table->dropForeign('tags_assigned_entity_id_foreign');
		});
		Schema::table('tags_assigned', function(Blueprint $table) {
			$table->dropForeign('tags_assigned_tag_id_foreign');
		});
		Schema::table('sponsored', function(Blueprint $table) {
			$table->dropForeign('sponsored_entity_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_p_cat_id_foreign');
		});
		Schema::table('product_options_sub', function(Blueprint $table) {
			$table->dropForeign('product_options_sub_p_cat_id_foreign');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_type_id_foreign');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_entity_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_payment_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_entity_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_payment_mode_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_consumer_id_foreign');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_entity_id_foreign');
		});
		Schema::table('consumers_addresses', function(Blueprint $table) {
			$table->dropForeign('consumers_addresses_consumer_user_id_foreign');
		});
		Schema::table('consumers_addresses', function(Blueprint $table) {
			$table->dropForeign('consumers_addresses_country_id_foreign');
		});
		Schema::table('consumers_addresses', function(Blueprint $table) {
			$table->dropForeign('consumers_addresses_state_id_foreign');
		});
		Schema::table('consumers_addresses', function(Blueprint $table) {
			$table->dropForeign('consumers_addresses_city_id_foreign');
		});
		Schema::table('affliliates', function(Blueprint $table) {
			$table->dropForeign('affliliates_affiliate_post_type_id_foreign');
		});
		Schema::table('affliliates', function(Blueprint $table) {
			$table->dropForeign('affliliates_affilitate_package_id_foreign');
		});
		Schema::table('affliliates', function(Blueprint $table) {
			$table->dropForeign('affliliates_user_id_foreign');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->dropForeign('taxes_tax_type_foreign');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->dropForeign('taxes_country_id_foreign');
		});
		Schema::table('state', function(Blueprint $table) {
			$table->dropForeign('state_country_id_foreign');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->dropForeign('city_state_id_foreign');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->dropForeign('city_country_id_foreign');
		});
		Schema::table('cuisine_assigned', function(Blueprint $table) {
			$table->dropForeign('cuisine_assigned_cuisine_id_foreign');
		});
		Schema::table('cuisine_assigned', function(Blueprint $table) {
			$table->dropForeign('cuisine_assigned_entity_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_order_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_product_id_foreign');
		});
		Schema::table('EntitiesSettings', function(Blueprint $table) {
			$table->dropForeign('EntitiesSettings_entity_id_foreign');
		});
	}
}