<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CuisineAssigned extends Eloquent {

	protected $table = 'cuisine_assigned';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cuisine_id', 'entity_id', 'status');

	public function Cuisines()
	{
		return $this->hasOne('\Cuisines', 'cuisine_id');
	}

	public function Entities()
	{
		return $this->hasOne('\Entities', 'entity_id');
	}

}